define([
    'backbone',
    'Layout',
    'Vent',
    'modules/page/user-menu/user-menu-view',
],
function(Backbone, Layout, vent, UserMenuView) {
    'use strict';

    describe('User Menu View', function() {
        var view;
        var $view;
        var layout;
        var header;


        describe('for an unauthenticated user', function() {
            beforeEach(function() {
                var model;

                layout = new Layout();
                layout.render();
                header = layout.getRegion('header');
                $(header.el).append('<button type="button" id="user-menu-btn"></button>');

                model = new Backbone.Model({
                    isAuthenticated: false,
                    isEnrolled: false,
                });

                view = new UserMenuView({
                    model: model,
                    panel: $('#user-menu'),
                    button: $('#user-menu-btn'),
                });
                layout.showChildView('menu', view);
                $view = view.$el;
            });

            it('does not have a link to About', function() {
                expect($view.find('#about-btn').length).toEqual(0);
            });

            it('does not have a link to Feedback', function() {
                expect($view.find('#feedback-btn').length).toEqual(0);
            });

            it('does not have a link to Preferences', function() {
                expect($view.find('#preferences-btn').length).toEqual(0);
            });

            it('has a link to Launchpad', function() {
                expect($view.find('#launchpad-btn').length).toEqual(1);
                expect($view.find('#launchpad-btn').text()).toEqual('Launchpad');
            });

            it('does not have a link to Logout', function() {
                expect($view.find('#logout-btn').length).toEqual(0);
            });
        });

        describe('for an authenticated but not facility-enrolled user', function() {
            beforeEach(function() {
                var model = new Backbone.Model({
                    isAuthenticated: true,
                    isEnrolled: false,
                });

                view = new UserMenuView({
                    model: model,
                    panel: $('#user-menu'),
                    button: $('#user-menu-btn'),
                });
                layout.showChildView('menu', view);
                $view = view.$el;
            });

            it('has a link to About', function() {
                expect($view.find('#about-btn').length).toEqual(1);
                expect($view.find('#about-btn').text()).toEqual('About');
            });

            it('does not have a link to Feedback', function() {
                expect($view.find('#feedback-btn').length).toEqual(0);
            });

            it('does not have a link to Preferences', function() {
                expect($view.find('#preferences-btn').length).toEqual(0);
            });

            it('has a link to Launchpad', function() {
                expect($view.find('#launchpad-btn').length).toEqual(1);
                expect($view.find('#launchpad-btn').text()).toEqual('Launchpad');
            });

            it('has a link to Logout', function() {
                expect($view.find('#logout-btn').length).toEqual(1);
                expect($view.find('#logout-btn').text()).toEqual('Logout');
            });
        });

        describe('for an authenticated and facility-enrolled user', function() {
            beforeEach(function() {
                var model = new Backbone.Model({
                    isAuthenticated: true,
                    isEnrolled: true,
                });

                view = new UserMenuView({
                    model: model,
                    panel: $('#user-menu'),
                    button: $('#user-menu-btn'),
                });
                layout.showChildView('menu', view);
                $view = view.$el;
            });

            it('has a link to About', function() {
                expect($view.find('#about-btn').length).toEqual(1);
                expect($view.find('#about-btn').text()).toEqual('About');
            });

            it('has a link to Feedback', function() {
                expect($view.find('#feedback-btn').length).toEqual(1);
                expect($view.find('#feedback-btn').text()).toEqual('Feedback');
            });

            it('has a link to Preferences', function() {
                expect($view.find('#preferences-btn').length).toEqual(1);
                expect($view.find('#preferences-btn').text()).toEqual('Preferences');
            });

            it('has a link to Launchpad', function() {
                expect($view.find('#launchpad-btn').length).toEqual(1);
                expect($view.find('#launchpad-btn').text()).toEqual('Launchpad');
            });

            it('has a link to Logout', function() {
                expect($view.find('#logout-btn').length).toEqual(1);
                expect($view.find('#logout-btn').text()).toEqual('Logout');
            });
        });

    });
});
